7234 Introduction                                       The 7234 plug-in front panel controls allow     changing the timebase, the trigger conditions,    the signal amplifiers, and the display of a       summary of control settings on the mainframe      display.  Whenever a plug-in control is           changed, the plug-in's vertical and timebase      settings are briefly displayed on the screen.     The display indicates the settings to be used     for the next acquisition.  The labels             displayed next to the `MTRACE 1`N through         `MTRACE 8`N keys indicate the name or label of    the displayed trace and the acquisition           parameters used when the waveform was acquired    and are updated with every waveform               acquisition.                                        Note that changes to the control settings       will not be reflected in the displayed            waveform until the 7234 has acquired new data,    since changing the plug-in acquisition            settings has no effect on previously acquired     waveforms.  Therefore, the settings indicated     when controls are changed may differ from         those displayed next to the trace keys when       the 7200A is in the Single or Sequence Trigger    Mode and has finished acquiring data.  Traces     displayed using channels not acquiring data       will indicate "NO DATA" in the trace label.   Display of Acquisition Parameters                       There are several displays which provide        parameter acquisition information.            Plug-in Status                                          The Plug-in Status screen displays all 7234     control settings.  The acquisition parameters     which do not have a dedicated control on the      front panel are changed from within this          screen.  Pressing the `MDISPLAY`N key or          pressing the `MMODIFY`N key (on the mainframe)    and the `MDISPLAY`N key  brings up the Plug-in    Status screen.                                      The acquisition parameters which do not have    a dedicated control on the front panel can be     changed from within this menu.  To select the     parameter to change, rotate the `MMove Box`N      soft knob until the box moves to the item to      be changed.  To change the item's value,          rotate the `MModify Value`N soft knob until       your choice appears within the box.  The list     of choices are shown in the lower right corner    of the menu, with the current choice in the       center of the list of options.                      The screen is divided into three main           sections:  Trigger Controls, Timebase             Controls, and Vertical Controls.              Vertical Status Screen                                  The Vertical Status screen contains a sub-      set of the control settings shown in the          Plug-in Status display so that the waveforms      can be viewed while the acquisition controls      are being changed.  The Vertical Status screen    appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      vertical section on the plug-in's front panel     or when selected from inside the Trigger or       Timebase status screens.                      Trigger Status Screen                                   The Trigger Status screen contains a sub-set    of the control settings shown in the Plug-in      Status display so that the waveforms can be       viewed while the acquisition controls are         being changed.  The Trigger Status screen         appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      trigger section on the plug-in's front panel      or when selected from inside the Timebase or      Vertical status screens.                      Timebase Status Screen                                  The Timebase Status screen contains a sub-      set of the control settings shown in the          Plug-in Status display so that the waveforms      can be viewed while the acquisition controls      are being changed.  The Timebase Status screen    appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      timebase section on the plug-in's front panel     or when selected from inside the Vertical or      Trigger status screens.                       Plug-in Controls                                        The following sections will describe all the    controls available to the user.               Vertical Controls                                       The Vertical controls adjust signal             amplification for each plug-in channel.  These    adjustments are made either with dedicated        front panel controls or from within the Plug-     in or Timebase Status screens.                      The `MCH1`N , `MCH2`N , `MCH3`N or, `MCH4`N     keys select which channel the Vertical            controls will modify. For example, when CH1 is    pressed, adjusting a Vertical control will        affect CH1 signal input, leaving the other        channels settings unchanged.  The channel's       LED next to the key is lit to indicate the        selected channel.                                   The `MSelect All Channels`N softkey is          located in the Plug-in and Vertical status        screens and is used to set all the vertical       control settings for every channel of the         plug-in to be the same as the vertical control    settings for the channel indicated to the         right of the "Vertical Controls" label.  The      channel select led's will be lit for all four     channels and modifiying any vertical controls     will affect CH1 thru CH4's signal input.            The `MV/DIV`N (Volts/Division) knob selects     the vertical sensitivity factor in multiples      of 1, 2, and 5.  The sensitivity range is 5 mV    to 1 V/div at both 1 M and 50  input            impedances with the variable sensitivity (as      described later) set to unity.                      The `MVariable Gain`N Knob provides a           variable vertical sensitivity within the V the    vertical range up to 2.5 times the V led is       lit next to the knob when the sensitivity is      between fixed settings.                             Pressing the `MVAR`N key toggles between 1.0    times the V currently selected Variable Gain      setting.  An LED next to the `MVAR`N key is       lit to indicate that the Variable Gain is         selected.  The Combined Volts/div and Variable    Gain settings for the currently selected          channel are displayed in the Status Message       Field for about thirty seconds while any          control is adjusted.                                `MProbe Attenuation`N indicates the probe       attenuation factor included in the vertical       sensitivity indicators. If attenuation-coded      probes are used, the probe contact rings          surrounding each channel's BNC connector          recognizes the attenuation factors of the         probes. If this type of probe is not used, the    probe attenuation can be selected in the          Plug-in Status screen or the Vertical Status      screen.  The choices are x1 to x1000.           Total V/Div                                           Total V/Div indicates the current setting of    the front panel Vertical Sensitivity control      multiplied by the variable sensitivity and the    probe attenuation.  Variable sensitivity is       adjusted (up to 2.5x the V/Div setting) with      the `MVAR`N knob inside of the `MV/Div`N knob.  Probes                                                Two Model 7200-P12 passive probes are           supplied with the 7234.  These probes have 1      M input impedance and approximately 15 pF        capacitance.  The system bandwidth with 7200-     P12 probes is DC to 250 MHz (typical) with        1M DC coupling, and less than 10 Hz to 250       MHz in AC coupling.                             Probe Calibration                                     To calibrate the 7200-P12 Probe, connect it     to one of the channel's BNC connectors.           Connect the probe's grounding alligator clip      to the front panel ground lug of the              oscilloscope and connect the tip to the signal    lug.  Use the `MAuto Setup`N key to obtain a      signal.  If over- or undershooting of the         displayed signal occurs, it is possible to        adjust the 7200-P12 Probe by inserting the        small screwdriver supplied with the probe         package into the trimmer on the probe's           barrel.  Turn the screwdriver either clockwise    or counter-clockwise to achieve the optimal       square wave contour.                            Input                                                 BNC type connectors are used for each           channel's signal inputs.  The maximum             permissible input voltage is 250 V (DC + peak     AC) in 1 M.                                        The `MCOUPLING`N keys select the method used    to couple the signal to the vertical amplifier    input.  Sequentially press key to select one      of four types of input coupling.  LED's to the    left of the `MCOUPLING`N keys indicate the        selection.  Possible selections are as            follows:                                          AC    with 1 M input impedance                   DC    with 1 M input impedance,                  GND   (appears open, as seen from the input               connector), and                           DC with 50  impedance.                             In the AC position, signals are coupled         capacitively, thus blocking the input signal's    DC component and limiting the signal              frequencies to more than 10 Hz.                     The maximum dissipation into 50  is 0.5        W, and signals will automatically be              disconnected whenever this level is exceeded.     A warning LED (OVLD) lights up indicating when    an overload condition has been detected.  The     input coupling is simultaneously switched to      GND.  The overload condition is reset by          removing the signal from the input and re-        selecting the desired input impedance again.        The `MOFFSET`N knob adjusts the voltage         offset used to position the signal within the     amplifier's input range.  The maximum offset      is > 12 times the fixed sensitivity setting       and is manually adjustable (or programmable)      in 0.02 division increments.  A pair of           upward- or downward-pointing arrows ( or         ) on the grid's upper or lower edge              indicate when the trace has been positioned       outside of the grid.                                The `MZero Offset`N key toggles between zero    offset and the currently selected offset          value.  An LED next to the key lights "ZERO"      to indicate zero offset.                            The `MBandwidth Limit`N field in the Plug-in    or Vertical Status screen can be used to          reduce the bandwidth from 500 MHz to 95 MHz in    50  and from 250 MHz to 95 MHz in 1 M.          This reduction in bandwidth is achieved with      an analog hardware lowpass filter, before the     digitizer, and is useful in reducing system       noise in cases where the signal frequency         components are below 95 MHz.  The filter rolls    off at about -18dB per octave (3-pole).             The `MEnhanced Res`N field in the Plug-in       and Vertical Status screens allows the user to    select the amount of digital filtering for        enhancing resolution. By reducing the system      bandwidth, both noise and signal above the        cutoff are effectively removed from the           resulting waveform. If the signal components      of interest are below the cutoff, then the        effective resolution can be improved beyond       the ADC's ideal resolution.  Selecting greater    values of this parameter, results in              progressively lower system bandwidths. Since      the ADC's each have 8 bits, selecting the         lowest value (8.0) removes the filter.            Indicated next to the number of bits is the       effective system bandwidth (calculated from       the theoretical filter bandwidth and the          unfiltered analog bandwidth.  Because extra       samples before and after the resulting            waveform record are required to do the digital    filtering, Enhanced Res cannot be used when       the trigger mode is Sequence.                 Timebase Controls                                       Timebase controls allows the user to select     the horizontal parameters used to acquire         data.  These parameters are Timebase, Random      Interleaved Sampling, Max Memory, Number of       Channels Acquiring Data, Sampling, Clock          (source), and if in sequence trigger mode the     Number of Segments and the Sequence Maximize      Option.                                             The `MTIMEBASE`N knob is used to select the     amount of time each horizontal division           represents.  The Timebase setting, the Max        Memory, the number of channels acquiring data,    and if in sequence mode, the number of            segments and the Sequence Maximize Option         determines the sampling frequency and the         number of sample points displayed per             division. The detented knob selects the           Timebase in a 1-2-5 sequence from 200 ps/DIV      to 10,000 sec/DIV.  The number of Point/div       and the Time/point is dispalyed in the Plug-in    status or Timebase Status screens. Depending      on the timebase setting, the following three      sampling modes are selectable: Random             Interleaved Sampling (RIS), Single Shot, and      Sequence.                                           The `MRandom Interleaved Sampling (RIS)`N       key turns on or off RIS acquisition mode          depending on the timebase setting. For the        7234, the RIS acquisition consists of many        single-shot acquisitions at 200 MS/s, each        with about 1/100th of the final Memory size.      For each acquisition the time between the         actual trigger signal and the next sampling       clock is recorded, and used to associate the      single-shot acquisition with one of 100           "leaves". When there is an acquisition for        each of 100 "leaves", the single-shot             waveforms are "interleaved" to form a RIS         waveform, with effectively 100 times the          single-shot sampling rate, or in this case 20     GS/s.  Because the triggers are randomly          associated with the sampling process              (uncorrelatd with the sampling clock), the        word random is used in Random Interleaved         Sampling.  This method requires repetitive        signal source, a stable trigger and a rep-rate    not correlated with the 200MS/s sample clock.       It is interesting to note that considerably     more than 100 randomly correlated triggers are    required to fully populate the 100 RIS leaves.    Based on statistical arguments, the nominal       factor is between 5 and 6 times for 100 leaves    (i.e. 500 to 600 triggers), but as many as 10     times is not impossible. Since the trigger        times are random, even though a 50 picosecond     spacing between leaves is used, each              individual leaf could have an error as large      as +- 25 picoseconds. The 7234 uses the "best"    100 acquisitions to form a RIS record (i.e. if    a newly acquired trigger has a smaller error      than the previously acquired trigger for that     leaf, the acquisition with the smallest error     is used. No averaging is done; nominally 80%      of the acquisitions are discarded.                  At timebase settings from 200 ps/DIV to 20      nsec/div, the 7234 automatically uses the RIS     mode for signal acquisition. When selected, an    "ON" led on the 7234 front-panel will be lit,     otherwise, the "ON" led is not lit and            single-shot acquisitions are used.  If the Max    Memory is set to 2K, there is no overlap          between single-shot and RIS.  If the memory       size is set to 20K, RIS or single shot may be     selected in the range 20nsec/div and .1           sec/div.  If the memory size is set to           50K, RIS or single shot may be selected in the    range 20nsec/div and .2 sec/div. If the          memory size is set to 100K, RIS or single shot    may be selected in the range 20nsec/div and .5    sec/div. If the memory size is set to            200K, RIS or single shot may be selected in       the range 20nsec/div and 1 sec/div. The          7234 can record waveforms in a single-shot        acquisition for timebase settings between 20      nsec and 200 msec/div.  Sampling rates up to      200 Megasamples/sec are possible in the           single-shot mode.                                   Two `MSampling`N options are available in       RIS mode, RANDOM and INTERPOLATED.  RIS data      has inherently non-uniform sampling intervals.    Because RIS waveforms are generally highly        oversampled (i.e. the effective sample rate is    many times higher than the signal bandwidth)      the non-uniformity of sample spacing has          subtle implications. The INTERPOLATED Sampling    option uses a linear interpolation algorithm      and the nearest neighboring samples to create     a RIS record with uniform sampling intervals.     The RANDOM option does not perform this           interpolation. INTERPOLATED is generally the      most useful choice. However in cases where the    fundamental assumptions of RIS sampling are in    question (not truly repetitive signal), RANDOM    Sampling is preferred. For example, if            Persistence Display is to be used to analyse      varying timing, and the timebase selection is     such that RIS is required, then RANDOM            Sampling should be used. Eye Diagram analyses     are inherently non-repetitive, and care must      be taken in attempting this kind of analysis      with RIS acquisition.                               When waveform parameters are computed on an     incomplete RIS record, and INTERPOLATED           Sampling has been chosen, the missing points      are filled in using linear interpolation. This    is not done when RANDOM Sampling is in effect.    The interpolated data are only used for the       parameter computations.  The original data are    used for waveform processing, display, and        output.                                             `MNumber of Acquisition Channels`N is a         field in the Plug-in and Timebase Status          screens that selects the number of channels       acquiring data.  Selection of 4 channels will     acquire data on all channels with a maximum of    50,000 samples per channel.  Reducing the         number of channels acquiring data will provide    acquisition data on channels 1 and 2 with         100,000 samples per channel, or channel 1 data    only with 200,000 samples.  200k RIS waveforms    can be acquired on all 4 channels.  Channels      1, 2, and 3 can be used as trigger sources        even if data is not acquired on it.                 When the trigger mode is Sequence, there are    two possible acquisition modes: sequential and    synchronous averaging. Sequential acquires        multiple segments and displays each               individually. Synchronous averaging acquires      multiple segments and averages them all           together, displaying one waveform.  When          sequential is the current acquisition mode,       the `MSelect Sync Avg`N softkey changes the       acquisition mode to synchronous averaging         which also includes alternate synchronous         averaging. When synchronous averaging is the      current acquisition mode, the `MSelect            Sequential`N softkey changes the acquisition      mode to sequential.                                 `MSequence Trigger Rate`N is a selectable       field in the Plug-in and Timebase Status          screens when the trigger mode is Sequence.        This field selection will determine the method    in which segments get acquired.  The two          methods are to mazimize Trigger Rate vs.          Points Per Segment. Selection of maximize         trigger rate will tradeoff the number of          segments and segment size for a greater           trigger rate (the time from one trigger to the    next). This method can acquire a maximum of       1000 (4000 with option L1) segments between       screen updates due to the limitations in          acquisition memory.  Selection of maximize        points per segment will maximize the number of    segments and points per segment.  This method     processes each segment as it is acquired.         This method can acquire a maximium of 4000        segments between screen updates because it is     not limited by acquisition memory, but by         processing memory.  The trigger rate will vary    with the length of each segment and the number    of channels acquiring data. When in Sequence      Mode, the approximate trigger rate is             displayed in the Plug-in and Timebase Status      screens.                                            `MNumber of Segments`N is a selectable field    in the Plug-in and Timebase Status screens        when the trigger mode is Sequence.  The Number    of segments indicates the number of segments      in a sweep.  The number of segments, the          timebase setting, the acquisition memory size,    the number of channels acquiring data, and the    sequence acquisition method determine the         number of data points per segment and the time    per point which is displayed in the Plug-in       and Timebase status screens.  Number of           segments can be selected from 1 to 1000 (4000)    segments when maximize trigger rate is            selected and 1 to 4000 segments when maximize     points per segment is selected.  The table        below shows the relationship between maximum      memory size, number of channels acquiring         data, and maximum number of segments for each     of the Sequence Maximize Options.                 Memory  # of Acq  Max # 0f Segs  Max # of Segs    Length  Channels  with Max Trig  with Max Pnts                      Rate           Per Seg          ----------------------------------------------    2K        4        20              4000                     2        20              4000                     1        20              4000           20K       4        200             4000                     2        200             4000                     1        200             4000           50K       4        500             4000                     2        500             4000                     1        500             4000           100K      4        500             4000                     2        1000            4000                     1        1000            4000           200K      4        500             4000                     2        1000            4000                     1        1000            4000             The `MMax Memory`N field appears in the         Plug-in and Timebase Status screens and allows    the user to specify the maximum number of         points to represent each waveform.  Together      with the timebase setting (and if in Sequence     mode, the number of segments and the Sequence     Maximize Option), it determines the segment       length and the time per point.  The choices       are 1K, 2K, 5K, ..., 200K (1M with L1 option)     points.  Acquire 1,000 samples to achieve         maximum waveform throughput. Obtaining 200,000    (1,000,000) points, provides a greater window     of the signal, requiring more time to process     the additional points.                          Points/div                                            Indicates the number of samples in each         division of the display grid, provided the        waveform is not decimated or expanded.          Time/point                                            Indicates the sample rate or the time           between digitized sample points for the           corresponding timebase setting.                     The `MClock`N field appears in the Plug-in      and Timebase Status screens and allows the        user to specify whether to used the Plug-in's     internal clock or an external clock which is      applied to the 7200A's rear panel.  With an       external clock, the suggested clock rate of       200 MHz is specified.                               The `MAverage mode`N field appears in the       Plug-in and Timebase Status screens and allows    the user to select between synchronous            averaging `M(STANDARD)`N or alternate             synchronous averaging `M(ALTERNATE).`N              Synchronous averaging acquires multiple         acquisitions and averages them together. There    is no history associated with this averaging      so that after the number of sweeps have been      acquired, averaged and displayed, re-arming       the plug-in will acquire an entirely new set      of sweeps. Synchronous averaging differs from     fast averaging in that the trigger rate is        guarranteed. Since no display updates occur       during the acquisition, the only dead time        between sweeps is due to reading and summing      the waveform data which is fixed based on the     points/sweep and the timebase setting. In fast    averaging, considerable time is lost between      sweeps when the waveform is updated on the        screen.                                             Alternate synchronous averaging is similar      to synchronous averaging except that every        other sweep is acquired with the complement of    the currently selected trigger slope. This is     most commonly used to subtract background         noise. Alternate synchronous averaging            produces a dual waveform. The ROOF function       can be used to isolate the averaged waveform      acquired on the selected trigger slope. The       FLOOR function can be used to isolate the         averaged waveform acquired on the opposite        trigger slope.  In alternate synchronous          averaging only Channel 1 acquires data and all    other channels may be used as trigger sources.      The `MNum Sweeps`N field appears on the         Plug-in and Timebase Status screens and allows    the user to select the number of sweeps which     will contribute to the average.                 Points/sweep                                          Indicates the number of samples acquired in     each sweep which also equals the number of        samples in the final averaged waveform.             The `MTurn ON Art Reject`N softkey appears      on the Plug-in and Timebase Status screens and    allows the user to turn on artifact rejection     during sychronous averaging and alternate         synchronous averaging.  When enabled, any         waveform with an underflow or overflow value      is not included in the computation.  If           Artifact Reject is turned OFF, any overflows      are set to the maximum possible value of the      ADC and any underflows to the minimum value.  Trigger Controls                                        The 7234 offers two independent triggering      methods: Standard and Smart Trigger.  Standard    trigger provides basic trigger functions which    can be controlled from the front panel.  Smart    Trigger adds additional qualifications to the     trigger source(s). The Smart Trigger key on       the plug-in front panel toggles between           selecting either method.  The LED indicates       when Smart Trigger is selected.  Smart Trigger    options can be adjusted either with dedicated     front panel controls or from within the Plug-     in or Trigger Status screens.                       The pair of `MSOURCE`N keys enable trigger      source selection as follows:                      CH 1    Selects Channel 1 as the trigger                  source, i.e., the signal connected to             the Channel 1 BNC input connector.        CH 2    Selects Channel 2 as the trigger                  source, i.e., the signal connected to             the Channel 2 BNC input connector.        CH 3    Selects Channel 3 as the trigger                  source, i.e., the signal connected to             the Channel 3 BNC input connector.        Line    Selects the line voltage which powers             the oscilloscope to provide a stable              display of signals synchronous with               the power line.                             The `MCOUPLING`N keys select the type of        signal coupling at the input of each trigger      circuit.  Note that the trigger coupling can      be adjusted independently for each trigger        source.  Therefore, a change of the trigger       source may also result in a change of the         trigger coupling LEDs since the coupling          associated with the newly selected source is      remembered.  The types of coupling are as         follows:                                          AC      Signals are capacitively coupled; DC               Levels are rejected and frequencies               below 8 Hz are attenuated.               LF REJ  Signals are DC coupled to the trigger              circuit and a low-pass filter network             attenuates frequencies above 50 kHz.              The LF trigger mode is used to                    trigger on low frequency signals.        HF REJ  Signals are coupled via a capacitive               high-pass filter network.  DC is                  rejected and signal frequencies below             50 kHz are attenuated. The HF trigger             mode is used to reject high frequency             signals.                                 DC      All of the signal's frequency                      components are coupled to the trigger             circuit.                                   The `MDELAY`N field is used to select the       function of the delay knob.  The choices are      TIME and PERCENT.  When delay is set as a         function of TIME, the delay knob adjusts the      amount of time the signal is recorded             before(pre_trigger) or after(post trigger) the    trigger occurs.  When delay unit is set to        PERCENT, the trigger delay can be positioned      any where on the screen and will remain           constant as the time per division is changed.       The `MDELAY`N knob is used to select the        Trigger Delay.  `MDELAY`N adjusts the amount      of signal recorded before(pre-trigger) or         after(post-trigger) the trigger occurs.  The      pre-trigger amount depends on the Timebase,       memory size, and if in Sequence trigger mode,     the number of segments.  The delay can be         adjusted in time or as a percentage of the        screen. The maximum limit is 10,000 record        lengths.  The arrow under the grid indicates      the trigger point of the displayed trace.         Trigger delay is locked to other plug-ins when    the timebase controls are locked.                   The `MZero Delay`N key toggles between the      selected delay setting and a trigger delay of     0.0 sec or 50 %, which would put the trigger      at the center of the grid. An LED next to the     key lights "ZERO" to indicate zero trigger        delay. Trigger delay is locked to other plug-     ins when the timebase controls are locked.          The `MLEVEL`N knob adjusts the voltage level    at which trigger will occur.  When the trigger    level is increased, the trigger circuit will      respond at a higher voltage level. If vertical    sensitivity is adjusted such that the             previously selected trigger level exceeds the     sensitivity range, then the trigger level is      automatically reduced to fit the new range.       The range of trigger levels is as follows:        Trigger Source  Trigger Range                     CH 1, 2, or 3   +-5 screen divisions *                                total gain                    LINE            none (zero-crossing is used)        The `MZero Level`N key toggles between the      selected trigger level and a trigger level of     0.0 Volts. An LED next to the key lights          "ZERO" to indicate zero trigger level.              The `MSLOPE`N key selects the signal edge       used to activate the trigger circuit.  The        slope of the trigger can be adjusted for each     individual trigger source and is indicated by     LEDs above the `MSLOPE`N key.                     POS        Triggers on a positive-going edge.     NEG        Triggers on a negative-going edge.       The Trigger Slope setting is not used if the    trigger source is Line.  The Trigger Slope        setting is always negative when `MHF Sync`N is    ON.                                                 A READY LED on each plug-in indicates that      the trigger circuit has been armed and the        plug-in is currently acquiring input signals.     The TRIG'D LED is lit whenever the time base      is stopped (normally after a valid trigger).        The `MSmart Trigger`N key toggles between       selecting the Standard Trigger and the Smart      Trigger.  Smart Trigger is setup from within      the Plug-in and Trigger status screens. An LED    next to the key will light "ON" to indicate       Smart Trigger is selected.  Smart Trigger         offers a variety of trigger qualifications        based on the ability of the 7234 to :               - To count a specified number of events(1 to    15,000,000)                                         - To measure time intervals(1 nsec up to 680    sec)                                                - To recognize a pattern input to the           selected trigger sources.  When Smart Trigger     is selected one of four triggering methods can    be selected:                                        `MSingle Source`N - Trigger on the selected     sourcei when the trigger conditions and one of    the following qualifications are met:               - Holdoff for 30 nsec up to 680 sec.              - Holdoff for 1 to 15,000,000 events.             - Interval < 30 nsec up to 680 sec.               - Interval > 30 nsec up to 680 sec.               - Pulse < 1 nsec up to 680 sec.                   - Pulse > 1 nsec up to 680 sec.                   `M.`N                                             - Trigger whenever the selected combination     of signals occurs and one of the following        qualifications are met:                             - Holdoff for 30 nsec up to 680 sec.              - Holdoff for 1 to 15,000,000 events.             - Interval < 30 nsec up to 680 sec.               - Interval > 30 nsec up to 680 sec.               - Time between patterns < trigger                 on entering(1 nsec up to 680 sec).                - Time between patterns > trigger on              entering(1 nsec up to 680 sec).                   - Pattern width < trigger on exiting              (1 nsec up to 680 sec).                           - Pattern width > trigger on exiting              (1 nsec up to 680 sec).                           `MState Qualified`N - Trigger whenever the      trigger source meets its trigger condition        during the selected pattern and one of the        following qualifications are met:                   - Wait for 10 nsec up to 680 sec.                 - And Before 10 nsec up to 680 sec.               - Trigger on 1 to 15,000,000 events.              `MTime Qualified`N - Trigger whenever the       trigger source meets its trigger condition        after the selected combination and one of the     following qualifications are met:                   - Wait for 10 nsec up to 680 sec.                 - And Before 10 nsec up to 680 sec.               - Trigger on 1 to 15,000,000 events.              The `MHF Sync`N field appears in the Plug-in    and Trigger Status screens and allows the user    to turn on and off the Hi Freq Sync.  When HF     Sync is ON, the trigger source has its            frequency rate divided.  Select ON to allow       stable triggering for sources greater than 200    MHz.  When HF Sync is ON, the trigger slope is    always negative regardless of what was            previously selected.  HF Sync can not be used     with Smart Trigger.                           Calibrate                                               The `MCalibrate`N key ensures overall           vertical, timebase, and trigger accuracy by       calibrating the plugin at it's current            setting.  Calibration is also performed when      the 7200A is powered, when Vertical Controls      are adjusted, and periodically thereafter.        There is a calibrate softkey located in all       Status screens.                               